<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SlotedDate extends Model 
{

    protected $table = 'sloted_dates';
    public $timestamps = true;
    protected $fillable = array('sloted_date', 'doctor_id');

    public function doctor()
    {
        return $this->hasOne('App\Models\User', 'doctor_id');
    }

    public function slotedTime()
    {
        return $this->hasMany('App\Models\DoctorSlot', 'sloted_date_id');
    }

}